﻿using System;
using NVCC.Models;

namespace NVCC.WebUI.Infrastructure
{
    public class UserSessionManager : IUserSessionManager
    {
        private User GetFromSession(string key)
        {
            if (HttpContextManager.Current.Session==null)
                throw new NullReferenceException("Session is null");
            
            return (User)HttpContextManager.Current.Session[key];
        }

        private void SetInSession(string key, object value)
        {
            if (HttpContextManager.Current.Session != null)
                HttpContextManager.Current.Session[key] = value;
        }

        public User UserProfile
        {
            get { return GetFromSession("VaUserProfile"); }
            set { SetInSession("VaUserProfile", value); }
        }

    }
}